// run.go

package main

import (
        "net/http"
        "fmt"
        "bytes"
        "io/ioutil"
)

func main() {
    params := map[string]string{
        "GatewayUserName" : "your username",
        "GatewayPassword" : "your password",
        "TransactionType" : "sale",
        "PaymentType" : "creditcard",
        "Amount" : "1.00",
        "CCNumber" : "4111111111111111",
        "CCExpDate" : "0120",
        "CVV" : "123",
    }

    xml := soapify(params)
    fmt.Println(xml)
    
    res, err := processTransaction(xml)
    if res == "" {
        fmt.Println("Error: ", err)
    } else {
        fmt.Println(res)
    }
}

/*
 * 
 */
func processTransaction (xml string) (string, string){
    url := "https://gateway.agms.com/roxapi/agms.asmx"
    var xmlStr = []byte(xml)
    req, err := http.NewRequest("POST", url, bytes.NewBuffer(xmlStr))
    req.Header.Set("SOAPAction", "https://gateway.agms.com/roxapi/ProcessTransaction")
    req.Header.Set("Content-Type", "text/xml; charset=utf-8")

    client := &http.Client{}
    resp, err := client.Do(req)
    if err != nil {
        panic(err)
    }
    defer resp.Body.Close()
    
    // fmt.Println("response Status:", resp.Status)
    // fmt.Println("response Headers:", resp.Header)
        
    if resp.Status == "200 OK" {
        body, _ := ioutil.ReadAll(resp.Body)
        return string(body), ""
    } else {
        return "", string(resp.Status)
    }
}


func soapify (request map[string]string ) (string) {
     const soapHeader =
    `<?xml version="1.0" encoding="utf-8"?>
<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ProcessTransaction xmlns="https://gateway.agms.com/roxapi/">
      <objparameters>`
    const soapFooter = 
      `</objparameters>
    </ProcessTransaction>
  </soap:Body>
</soap:Envelope>`
    xml := ""
    for key, value := range request {
        xml = xml + "<" + key + ">" + value + "</" + key + ">"
    }
    
    return soapHeader + xml + soapFooter
}
